using System;

namespace Server.Items
{
	public abstract class BaseSilkPants : BaseClothing
	{
		public BaseSilkPants( int itemID ) : this( itemID, 0 )
		{
		}

		public BaseSilkPants( int itemID, int hue ) : base( itemID, Layer.Pants, hue )
		{
		}

        public BaseSilkPants(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x152e, 0x152f )]
	public class SilkShortPants : BaseSilkPants
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 25; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkShortPants() : this( 0 )
		{
		}

		[Constructable]
		public SilkShortPants( int hue ) : base( 0x152E, hue )
		{
			Weight = 2.0;
            Name = "Silk Short Pants";
		}

        public SilkShortPants(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x1539, 0x153a )]
    public class SilkLongPants : BaseSilkPants
	{

        public override int BasePhysicalResistance { get { return 3; } }
        public override int BaseFireResistance { get { return 2; } }
        public override int BaseColdResistance { get { return 4; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 25; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkLongPants() : this( 0 )
		{
		}

		[Constructable]
		public SilkLongPants( int hue ) : base( 0x1539, hue )
		{
			Weight = 2.0;
            Name = "Silk Long Pants";
		}

        public SilkLongPants(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x279B, 0x27E6 )]
	public class SilkTattsukeHakama : BaseSilkPants
	{

        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 25; } }
        public override int InitMaxHits { get { return 30; } }

		[Constructable]
		public SilkTattsukeHakama() : this( 0 )
		{
		}

		[Constructable]
		public SilkTattsukeHakama( int hue ) : base( 0x279B, hue )
		{
			Weight = 2.0;
            Name = "Silk Tattsuke Hakama";
		}

        public SilkTattsukeHakama(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[FlipableAttribute( 0x2FC3, 0x3179 )]
	public class SilkElvenPants : BaseSilkPants
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 25; } }
        public override int InitMaxHits { get { return 30; } }

		public override Race RequiredRace { get { return Race.Elf; } }

		[Constructable]
		public SilkElvenPants() : this( 0 )
		{
		}

		[Constructable]
		public SilkElvenPants( int hue ) : base( 0x2FC3, hue )
		{
			Weight = 2.0;
            Name = "Elven Silk Pants";
		}

        public SilkElvenPants(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();
		}
	}
}